/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.curses;

import com.megacrit.cardcrawl.actions.common.LoseHPAction;
import com.megacrit.cardcrawl.actions.utility.UseCardAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class Pain
extends AbstractCard {
    public static final String ID = "Pain";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Pain");
    public static final String NAME = Pain.cardStrings.NAME;
    public static final String DESCRIPTION = Pain.cardStrings.DESCRIPTION;
    private static final int LOSE_HP_AMT = 1;
    private static final int COST = -2;
    private static final int POOL = 1;

    public Pain() {
        super(ID, NAME, null, "curse/pain", -2, DESCRIPTION, AbstractCard.CardType.CURSE, AbstractCard.CardColor.CURSE, AbstractCard.CardRarity.CURSE, AbstractCard.CardTarget.NONE, 1);
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        if (p.hasRelic("Blue Candle")) {
            this.useBlueCandle(p);
        } else {
            AbstractDungeon.actionManager.addToBottom(new UseCardAction(this));
        }
    }

    @Override
    public void triggerOnOtherCardPlayed(AbstractCard c) {
        AbstractDungeon.actionManager.addToTop(new LoseHPAction(AbstractDungeon.player, AbstractDungeon.player, 1));
    }

    @Override
    public AbstractCard makeCopy() {
        return new Pain();
    }

    @Override
    public void upgrade() {
    }
}

